/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.mixin;

import com.ludwici.slimeoverhaul.Content;
import com.ludwici.slimeoverhaul.entity.custom.elementals.FlameSlime;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract boolean fireImmune();

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setUnderwaterMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V")}, cancellable=true)
    protected void checkEarthSlimeItemsInWater(CallbackInfo ci) {
        if (this.getItem().is((Item)Content.EARTH_SLIME_BALL.get()) || this.getItem().is(((Block)Content.EARTH_SLIME_BLOCK.get()).asItem())) {
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x * (double)0.99f, vec3.y - (double)(vec3.y < (double)-0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.99f);
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    protected void checkFireSlimeBallInWater(CallbackInfo ci) {
        if (!this.level().isClientSide()) {
            if (this.getItem().is((Item)Content.FIRE_SLIME_BALL.get()) && this.isInWater()) {
                this.discard();
            }
            if (!this.fireImmune()) {
                for (FlameSlime entity : this.level().getEntitiesOfClass(FlameSlime.class, this.getBoundingBox().inflate(0.5, 0.0, 0.5), flameSlime -> !flameSlime.isTiny())) {
                    this.igniteForSeconds(5.0f);
                }
            }
        }
    }
}

